<?php
require_once __DIR__ . '/config/bootstrap.php';
require_once __DIR__ . '/src/WhatsAppClient.php';

// Test sending a message after initiating a conversation
$wa = new WhatsAppClient();
$yourPhone = '923336781858'; // Your personal number

echo "=== WhatsApp Message Test ===\n\n";
echo "Instructions:\n";
echo "1. Send ANY message from +92 333 6781858 to your business number: +971 52 166 5136\n";
echo "2. Wait for the message to arrive\n";
echo "3. Press Enter here to send a reply\n\n";
echo "Waiting for you to send the message... (Press Enter when done): ";
$handle = fopen("php://stdin", "r");
$line = fgets($handle);
fclose($handle);

echo "\nSending free-form message...\n";
list($code, $resp) = $wa->sendFreeForm($yourPhone, "✅ Success! Your TradeNotify system is working!\n\nThis is an automated test message from your MT5 notification system.");

$response = json_decode($resp, true);

if ($code == 200) {
    echo "✅ Message sent successfully!\n";
    echo "Message ID: " . ($response['messages'][0]['id'] ?? 'N/A') . "\n";
    echo "\nCheck your phone (+92 333 6781858) - you should see the message!\n";
} else {
    echo "❌ Failed to send:\n";
    echo json_encode($response, JSON_PRETTY_PRINT) . "\n";
}
