<?php
// Test MT5 authentication with detailed debugging

$server = 'mt5.skylinkstrader.com:443';
$login = '1023';
$password = 'Ab@it1023sky#'; // Correct password from .env
$build = '4330';
$agent = 'WebAPI';

echo "Starting MT5 authentication test...\n\n";

// Initialize cURL
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_SSL_VERIFYHOST => false,
    CURLOPT_MAXCONNECTS => 1,
    CURLOPT_HTTPHEADER => ['Connection: Keep-Alive'],
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HEADER => true,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_USERAGENT => 'MT5-WebAPI-Client/1.0',
    CURLOPT_COOKIEFILE => '',
    CURLOPT_COOKIEJAR => '',
    CURLOPT_VERBOSE => true, // Enable verbose output
]);

// Redirect verbose output to stderr
$verbose = fopen('php://stderr', 'w');
curl_setopt($curl, CURLOPT_STDERR, $verbose);

// Step 1: Auth start
echo "Step 1: Auth start\n";
$path = '/api/auth/start?version=' . $build . '&agent=' . urlencode($agent) . '&login=' . $login . '&type=manager';
$url = 'https://' . $server . $path;
echo "URL: $url\n";

curl_setopt($curl, CURLOPT_URL, $url);
curl_setopt($curl, CURLOPT_POST, false);

$response = curl_exec($curl);
$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
$headerSize = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
$headers = substr($response, 0, $headerSize);
$body = substr($response, $headerSize);

echo "HTTP Code: $httpCode\n";
echo "Response Body: $body\n\n";

if ($httpCode !== 200) {
    die("Auth start failed\n");
}

$data = json_decode($body, true);
if (!isset($data['srv_rand'])) {
    die("No srv_rand in response\n");
}

$srv_rand = $data['srv_rand'];
echo "srv_rand: $srv_rand\n";

// Step 2: Calculate password hash
echo "\nStep 2: Calculate password hash\n";
$password_utf16 = mb_convert_encoding($password, 'UTF-16LE', 'UTF-8');
$password_md5 = md5($password_utf16, true);
$password_hash = md5($password_md5 . 'WebAPI', true);
$srv_rand_bin = hex2bin($srv_rand);
$srv_rand_answer_input = $password_hash . $srv_rand_bin;
$srv_rand_answer = md5($srv_rand_answer_input);

echo "srv_rand_answer: $srv_rand_answer\n";

// Generate client random
$cli_rand_buf = random_bytes(16);
$cli_rand = bin2hex($cli_rand_buf);
echo "cli_rand: $cli_rand\n";

// Step 3: Auth answer
echo "\nStep 3: Auth answer\n";
$path = '/api/auth/answer?srv_rand_answer=' . $srv_rand_answer . '&cli_rand=' . $cli_rand;
$url = 'https://' . $server . $path;
echo "URL: $url\n";

curl_setopt($curl, CURLOPT_URL, $url);
curl_setopt($curl, CURLOPT_POST, false);

$response = curl_exec($curl);
$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
$headerSize = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
$headers = substr($response, 0, $headerSize);
$body = substr($response, $headerSize);

echo "HTTP Code: $httpCode\n";
echo "Headers:\n$headers\n";
echo "Response Body: $body\n";

if ($httpCode === 200) {
    echo "\n✓ Authentication successful!\n";
} else {
    echo "\n✗ Authentication failed with HTTP $httpCode\n";
}

curl_close($curl);
fclose($verbose);
