<?php
// test_mt5.php - Test MT5 accounts endpoint
require_once __DIR__ . '/config/bootstrap.php';
require_once __DIR__ . '/src/MT5WebAPI.php';

echo "Testing MT5 Accounts Endpoint...\n\n";

// Test 1: Database connection
try {
    $pdo = get_pdo();
    echo "✓ Database connection OK\n";
} catch (Exception $e) {
    echo "✗ Database connection FAILED: " . $e->getMessage() . "\n";
    exit;
}

// Test 2: Check if users table has data
try {
    $res = $pdo->query('SELECT COUNT(*) as count FROM users');
    $count = $res->fetch();
    echo "✓ Users table has {$count['count']} users\n";
} catch (Exception $e) {
    echo "✗ Users query FAILED: " . $e->getMessage() . "\n";
}

// Test 3: Check MT5 accounts in database
try {
    $res = $pdo->query('SELECT COUNT(*) as count FROM mt5_accounts');
    $count = $res->fetch();
    echo "✓ MT5 accounts table has {$count['count']} accounts\n";
    
    $res = $pdo->query('SELECT u.id, u.name, a.mt5_login FROM users u LEFT JOIN mt5_accounts a ON u.id=a.user_id WHERE a.mt5_login IS NOT NULL LIMIT 5');
    $accounts = $res->fetchAll(PDO::FETCH_ASSOC);
    if ($accounts) {
        echo "  Sample accounts:\n";
        foreach ($accounts as $acc) {
            echo "  - {$acc['name']} (Login: {$acc['mt5_login']})\n";
        }
    } else {
        echo "  No accounts with MT5 login found\n";
    }
} catch (Exception $e) {
    echo "✗ MT5 accounts query FAILED: " . $e->getMessage() . "\n";
}

// Test 4: Try MT5 Web API
echo "\nTesting MT5 Web API...\n";
try {
    $mt5 = new MT5WebAPI();
    echo "✓ MT5WebAPI class instantiated\n";
    $accounts = $mt5->getAccounts();
    echo "✓ MT5 API returned " . count($accounts) . " accounts\n";
    if ($accounts && count($accounts) > 0) {
        echo "  Sample account: " . print_r($accounts[0], true) . "\n";
    }
} catch (Exception $e) {
    echo "✗ MT5 API FAILED: " . $e->getMessage() . "\n";
}

echo "\nDone!\n";
