-- Seed sample users
INSERT INTO users (name, phone, wa_optin_at) VALUES
('Alice', '+12025550101', NOW()),
('Bob', '+12025550102', NOW()),
('Charlie', '+12025550103', NOW()),
('Diana', '+12025550104', NOW()),
('Eve', '+12025550105', NOW());

-- Seed sample templates
INSERT INTO templates (name, wa_template_name, body, required_vars) VALUES
('trade_open', 'trade_open_tpl', 'Trade opened: {{symbol}} {{side}} {{volume}} @{{price}}', 'symbol,side,volume,price'),
('trade_close', 'trade_close_tpl', 'Trade closed: {{symbol}} {{side}} {{volume}} @{{price}} PnL: {{pnl}}', 'symbol,side,volume,price,pnl'),
('deposit', 'deposit_tpl', 'Deposit: {{amount}} {{currency}}. New balance: {{balance_after}}', 'amount,currency,balance_after'),
('withdrawal', 'withdrawal_tpl', 'Withdrawal: {{amount}} {{currency}}. New balance: {{balance_after}}', 'amount,currency,balance_after'),
('margin_alert', 'margin_alert_tpl', 'Margin Alert! Equity: {{equity}}, Margin Level: {{margin_level}}%', 'equity,margin_level');

-- Seed default triggers
INSERT INTO triggers (name, description, enabled, threshold) VALUES
('trade_open', 'Notify on trade open', 1, NULL),
('trade_close', 'Notify on trade close', 1, NULL),
('deposit', 'Notify on deposit', 1, NULL),
('withdrawal', 'Notify on withdrawal', 1, NULL),
('margin_alert', 'Notify on margin alert', 1, 100.0);
