<?php
// /webhooks/mt5.php
require_once __DIR__ . '/../../vendor/autoload.php';
require_once __DIR__ . '/../../config/bootstrap.php';

// Load secret from env
$secret = getenv('WEBHOOK_SECRET');

// Get raw POST body
$body = file_get_contents('php://input');
$signature = $_SERVER['HTTP_X_MT5_SIGNATURE'] ?? '';

// Verify HMAC
$expected = hash_hmac('sha256', $body, $secret);
if (!hash_equals($expected, $signature)) {
    http_response_code(401);
    echo json_encode(['error' => 'Invalid signature']);
    exit;
}

// Parse JSON
$data = json_decode($body, true);
if (!$data || !isset($data['event'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid payload']);
    exit;
}

// Store event in DB
try {
    $pdo = get_pdo();
    $stmt = $pdo->prepare('INSERT INTO events (type, payload, status) VALUES (?, ?, ?)');
    $stmt->execute([
        $data['event'],
        json_encode($data),
        'pending'
    ]);
    http_response_code(200);
    echo json_encode(['success' => true]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'DB error']);
}
