<?php
// public/index.php
require_once __DIR__ . '/../vendor/autoload.php';
?><!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TradeNotify Admin</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gradient-to-br from-blue-50 to-gray-100 min-h-screen">
    <nav class="bg-white shadow mb-6">
        <div class="container mx-auto px-4 py-3 flex justify-between items-center">
            <span class="text-2xl font-extrabold text-blue-700 tracking-tight">TradeNotify Admin</span>
            <span class="text-sm text-gray-500">Dashboard</span>
        </div>
    </nav>
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
            <div class="bg-white rounded-xl shadow p-6 flex flex-col items-center">
                <div class="text-3xl font-bold text-blue-600 mb-2">5</div>
                <div class="text-gray-600">Active Users</div>
            </div>
            <div class="bg-white rounded-xl shadow p-6 flex flex-col items-center">
                <div class="text-3xl font-bold text-green-600 mb-2">12</div>
                <div class="text-gray-600">Triggers Enabled</div>
            </div>
            <div class="bg-white rounded-xl shadow p-6 flex flex-col items-center">
                <div class="text-3xl font-bold text-purple-600 mb-2">8</div>
                <div class="text-gray-600">Templates</div>
            </div>
        </div>
        <div class="flex flex-wrap gap-2 mb-6 justify-center">
            <button class="tab px-4 py-2 rounded bg-pink-100 text-pink-700 font-semibold hover:bg-pink-200" data-tab="notifications">Notifications</button>
            <button class="tab px-4 py-2 rounded bg-blue-100 text-blue-700 font-semibold hover:bg-blue-200" data-tab="triggers">Triggers</button>
            <button class="tab px-4 py-2 rounded bg-green-100 text-green-700 font-semibold hover:bg-green-200" data-tab="templates">Templates</button>
            <button class="tab px-4 py-2 rounded bg-purple-100 text-purple-700 font-semibold hover:bg-purple-200" data-tab="users">Users & Accounts</button>
            <button class="tab px-4 py-2 rounded bg-yellow-100 text-yellow-700 font-semibold hover:bg-yellow-200" data-tab="logs">Logs</button>
            <button class="tab px-4 py-2 rounded bg-gray-100 text-gray-700 font-semibold hover:bg-gray-200" data-tab="settings">Settings</button>
            <button id="mt5-status-btn" class="px-4 py-2 rounded bg-indigo-100 text-indigo-700 font-semibold hover:bg-indigo-200">Check MT5 Connection</button>
    <button id="create-notification-btn" class="px-4 py-2 rounded bg-pink-100 text-pink-700 font-semibold hover:bg-pink-200">Create Notification</button>
        </div>
        <div id="mt5-status-result" class="text-center text-sm mt-2"></div>
        <div id="tab-content" class="bg-white rounded-xl shadow p-6 min-h-[300px]">
            <!-- Dynamic tab content will appear here -->
            <div class="text-center text-gray-400">Select a tab to view details.</div>
        </div>
        <!-- Notification Modal -->
        <div id="notification-modal" class="fixed inset-0 bg-black bg-opacity-40 flex items-center justify-center z-50 hidden">
            <div class="bg-white rounded-xl shadow-lg p-8 w-full max-w-lg">
                <h2 class="text-xl font-bold mb-4">Create Notification</h2>
                <div id="notification-step-1">
                    <label class="block mb-2 font-semibold">Step 1: Select Client(s)</label>
                    <div id="clients-list" class="w-full mb-4 p-2 border rounded max-h-72 overflow-y-auto"></div>
                    <button id="notification-next-1" class="px-4 py-2 rounded bg-blue-500 text-white">Next</button>
                </div>
                <div id="notification-step-2" class="hidden">
                    <label class="block mb-2 font-semibold">Step 2: Select Trigger</label>
                    <select id="notification-trigger" class="w-full mb-4 p-2 border rounded">
                        <option value="open_trade">Start Trading (Open Trade)</option>
                        <option value="close_trade">Close Trade</option>
                        <option value="deposit">Deposit</option>
                        <option value="withdrawal">Withdrawal</option>
                        <option value="margin_call">Margin Call</option>
                        <option value="stop_out">Stop Out</option>
                    </select>
                    <div class="flex gap-2">
                        <button id="notification-back-2" class="px-4 py-2 rounded bg-gray-300 text-gray-700">Back</button>
                        <button id="notification-next-2" class="px-4 py-2 rounded bg-blue-500 text-white">Next</button>
                    </div>
                </div>
                <div id="notification-step-3" class="hidden">
                    <label class="block mb-2 font-semibold">Step 3: Compose Message</label>
                    <div id="placeholders-list" class="mb-3"></div>
                    <textarea id="notification-message" class="w-full mb-4 p-2 border rounded" rows="4" placeholder="Type your message. Click placeholders above to insert."></textarea>
                    <div class="flex gap-2">
                        <button id="notification-back-3" class="px-4 py-2 rounded bg-gray-300 text-gray-700">Back</button>
                        <button id="notification-save" class="px-4 py-2 rounded bg-green-500 text-white">Save Notification Rule</button>
                    </div>
                </div>
                <button id="notification-cancel" class="mt-4 px-4 py-2 rounded bg-gray-300 text-gray-700">Cancel</button>
            </div>
        </div>
        </div>
    </div>
    <footer class="mt-12 text-center text-xs text-gray-400">&copy; <?=date('Y')?> TradeNotify</footer>
                <script src="/assets/admin.js"></script>
                <script>
                document.getElementById('mt5-status-btn').onclick = function() {
                        fetch('/mt5_status.php')
                            .then(r => r.json())
                            .then(d => {
                                var el = document.getElementById('mt5-status-result');
                                if (d.status) {
                                    el.textContent = 'MT5 Connected';
                                    el.className = 'text-center text-sm mt-2 text-green-600';
                                } else {
                                    el.textContent = 'MT5 Not Connected: ' + (d.error || 'Unknown error');
                                    el.className = 'text-center text-sm mt-2 text-red-600';
                                }
                            })
                            .catch(() => {
                                var el = document.getElementById('mt5-status-result');
                                el.textContent = 'MT5 Not Connected (API error)';
                                el.className = 'text-center text-sm mt-2 text-red-600';
                            });
                };
                </script>
</body>
</html>
