-- Migration: Add Notifications System
-- Run this SQL to add notification tables to your database

-- Table to store notification rules
CREATE TABLE IF NOT EXISTS notifications (
    id INT AUTO_INCREMENT PRIMARY KEY,
    client_id VARCHAR(50) NOT NULL COMMENT 'MT5 Client RecordID',
    client_name VARCHAR(255),
    client_phone VARCHAR(50),
    account_logins TEXT COMMENT 'JSON array of account login numbers',
    trigger_type VARCHAR(50) NOT NULL COMMENT 'open_trade, close_trade, deposit, withdrawal, margin_call, stop_out',
    message TEXT NOT NULL COMMENT 'WhatsApp message template with placeholders',
    enabled TINYINT(1) DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_enabled (enabled),
    INDEX idx_trigger (trigger_type),
    INDEX idx_client (client_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table to track sent notifications (prevent duplicates)
CREATE TABLE IF NOT EXISTS notification_history (
    id INT AUTO_INCREMENT PRIMARY KEY,
    notification_id INT NOT NULL,
    client_id VARCHAR(50) NOT NULL,
    account_login INT NOT NULL,
    trigger_type VARCHAR(50) NOT NULL,
    event_id VARCHAR(255) COMMENT 'MT5 deal/position/balance change ID',
    event_data TEXT COMMENT 'JSON snapshot of event data',
    message_sent TEXT,
    sent_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    wa_message_id VARCHAR(255),
    status ENUM('sent', 'failed', 'pending') DEFAULT 'sent',
    error_message TEXT,
    FOREIGN KEY (notification_id) REFERENCES notifications(id) ON DELETE CASCADE,
    UNIQUE KEY unique_event (notification_id, event_id),
    INDEX idx_sent_at (sent_at),
    INDEX idx_status (status)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table to track last checked time for each notification (for monitoring)
CREATE TABLE IF NOT EXISTS notification_checkpoints (
    notification_id INT PRIMARY KEY,
    last_checked_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    last_event_id VARCHAR(255),
    FOREIGN KEY (notification_id) REFERENCES notifications(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
