<?php
// bin/mt5_monitor_withdrawal.php
require_once __DIR__ . '/../vendor/autoload.php';

// Include your MT5 API class
require_once __DIR__ . '/../mt5_test22.php';

// MT5 connection settings
$mt5_server = 'mt5.skylinkstrader.com:443'; // Change to your MT5 server
$mt5_login = '1023';        // Manager login
$mt5_password = 'Ab@it1023sky#';  // Manager password
$mt5_build = '4330';                 // MT5 build number
$mt5_agent = 'WebAPI';   // Agent name
$account_to_monitor = '10001';

// Track last withdrawal id (simple file-based persistence)
$last_id_file = __DIR__ . '/last_withdrawal_id.txt';
$last_id = @file_get_contents($last_id_file);

$mt5 = new CMT5Request();
if (!$mt5->Init($mt5_server)) {
    die('MT5 Init failed: ' . $mt5->last_error);
}
if (!$mt5->Auth($mt5_login, $mt5_password, $mt5_build, $mt5_agent)) {
    die('MT5 Auth failed: ' . $mt5->last_error);
}

// Fetch withdrawals for account 10001
// Replace with correct endpoint for your MT5 Web API
$resp = $mt5->Get('/api/user/withdrawals?login=' . $account_to_monitor);
if ($resp === false) {
    die('MT5 withdrawal fetch failed: ' . $mt5->last_error);
}
$data = json_decode($resp, true);
if (!$data || !isset($data['withdrawals'])) {
    die('No withdrawals found or invalid response');
}

// Find new withdrawals
foreach ($data['withdrawals'] as $withdrawal) {
    if ($last_id && $withdrawal['transaction_id'] <= $last_id) continue;
    // Prepare webhook payload
    $payload = [
        'event' => 'withdrawal',
        'login' => $account_to_monitor,
        'amount' => $withdrawal['amount'],
        'currency' => $withdrawal['currency'],
        'transaction_id' => $withdrawal['transaction_id'],
        'balance_after' => $withdrawal['balance_after']
    ];
    // Send to TradeNotify webhook
    $ch = curl_init('http://localhost/webhooks/mt5.php');
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'X-MT5-Signature: ' . hash_hmac('sha256', json_encode($payload), getenv('WEBHOOK_SECRET'))
    ]);
    $resp = curl_exec($ch);
    curl_close($ch);
    // Update last_id
    file_put_contents($last_id_file, $withdrawal['transaction_id']);
    echo "Withdrawal event sent for transaction_id: " . $withdrawal['transaction_id'] . "\n";
}
