<?php
// bin/dispatch.php
require_once __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/../config/bootstrap.php';
require_once __DIR__ . '/../src/WhatsAppClient.php';

$pdo = get_pdo();
$wa = new WhatsAppClient();

function getRecipients($event) {
    global $pdo;
    $login = $event['payload']['login'] ?? null;
    if (!$login) return [];
    $stmt = $pdo->prepare('SELECT u.id, u.phone FROM users u JOIN mt5_accounts a ON u.id=a.user_id WHERE a.mt5_login=?');
    $stmt->execute([$login]);
    return $stmt->fetchAll();
}

function getTemplate($type) {
    global $pdo;
    $stmt = $pdo->prepare('SELECT * FROM templates WHERE name=?');
    $stmt->execute([$type]);
    return $stmt->fetch();
}

function renderVars($body, $vars) {
    foreach ($vars as $k=>$v) {
        $body = str_replace('{{'.$k.'}}', $v, $body);
    }
    return $body;
}

function isSessionActive($userId) {
    // Placeholder: always true for demo
    return true;
}

function updateMessageStatus($msgId, $status) {
    global $pdo;
    $stmt = $pdo->prepare('UPDATE messages SET status=? WHERE id=?');
    $stmt->execute([$status, $msgId]);
}

function exponentialBackoff($attempt) {
    return pow(2, $attempt);
}

$stmt = $pdo->query("SELECT * FROM events WHERE status='pending'");
$events = $stmt->fetchAll();
foreach ($events as $event) {
    $recipients = getRecipients($event);
    $template = getTemplate($event['type']);
    foreach ($recipients as $user) {
        $body = renderVars($template['body'], $event['payload']);
        $msgType = isSessionActive($user['id']) ? 'freeform' : 'template';
        $attempt = 0;
        $maxAttempts = 3;
        $sent = false;
        while ($attempt < $maxAttempts && !$sent) {
            if ($msgType == 'freeform') {
                list($code, $resp) = $wa->sendFreeForm($user['phone'], $body);
            } else {
                list($code, $resp) = $wa->sendTemplate($user['phone'], $template['wa_template_name'], array_values($event['payload']));
            }
            $respData = json_decode($resp, true);
            $waMsgId = $respData['messages'][0]['id'] ?? null;
            $status = ($code == 200 && $waMsgId) ? 'sent' : 'failed';
            $stmt = $pdo->prepare('INSERT INTO messages (event_id, user_id, wa_message_id, status, sent_at) VALUES (?, ?, ?, ?, NOW())');
            $stmt->execute([$event['id'], $user['id'], $waMsgId, $status]);
            if ($status == 'sent') {
                $sent = true;
            } elseif (in_array($code, [429,500,502,503,504])) {
                sleep(exponentialBackoff($attempt));
                $attempt++;
            } else {
                break;
            }
        }
    }
    $pdo->prepare("UPDATE events SET status='processed' WHERE id=?")->execute([$event['id']]);
}
echo "Dispatch complete\n";
