<?php
require_once __DIR__ . '/../config/bootstrap.php';
require_once __DIR__ . '/../src/WhatsAppClient.php';

header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);
$wa = new WhatsAppClient();
$to = $data['phone'] ?? '';
$msg = $data['message'] ?? '';

if (!$to || !$msg) {
  echo json_encode(['success'=>false, 'error'=>'Missing phone or message']);
  exit;
}

list($code, $resp) = $wa->sendFreeForm($to, $msg);
$response = json_decode($resp, true);

if ($code == 200) {
  echo json_encode(['success'=>true, 'response' => $response]);
} else {
  echo json_encode([
    'success'=>false, 
    'error'=>$response, 
    'http_code'=>$code,
    'raw_response' => $resp
  ]);
}
