<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../config/bootstrap.php';
$pdo = get_pdo();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
	$data = json_decode(file_get_contents('php://input'), true);
	if ($data['action'] === 'add') {
		$stmt = $pdo->prepare('INSERT INTO templates (name, wa_template_name, body, required_vars) VALUES (?, ?, ?, ?)');
		$stmt->execute([$data['name'], $data['wa_template_name'], $data['body'], $data['required_vars']]);
		echo json_encode(['success'=>true]);
		exit;
	}
	if ($data['action'] === 'edit') {
		$stmt = $pdo->prepare('UPDATE templates SET name=?, wa_template_name=?, body=?, required_vars=? WHERE name=?');
		$stmt->execute([$data['name'], $data['wa_template_name'], $data['body'], $data['required_vars'], $data['original_name']]);
		echo json_encode(['success'=>true]);
		exit;
	}
	if ($data['action'] === 'delete') {
		$stmt = $pdo->prepare('DELETE FROM templates WHERE name=?');
		$stmt->execute([$data['name']]);
		echo json_encode(['success'=>true]);
		exit;
	}
}
if (isset($_GET['name'])) {
	$stmt = $pdo->prepare('SELECT * FROM templates WHERE name=?');
	$stmt->execute([$_GET['name']]);
	echo json_encode($stmt->fetch());
	exit;
}
$res = $pdo->query('SELECT name, wa_template_name, body, required_vars FROM templates');
echo json_encode($res->fetchAll());
