<?php
require_once __DIR__ . '/../config/bootstrap.php';
$pdo = get_pdo();
$sqlFile = __DIR__ . '/../database/notifications_migration.sql';
if (!file_exists($sqlFile)) { http_response_code(500); echo "Missing SQL migration file"; exit; }
$sql = file_get_contents($sqlFile);
// Split on semicolons that end a statement
$stmts = array_filter(array_map('trim', preg_split('/;\s*\n/', $sql)));
$applied = 0;
try {
    $pdo->beginTransaction();
    foreach ($stmts as $stmt) {
        if ($stmt === '' || stripos($stmt, '--') === 0) continue;
        $pdo->exec($stmt);
        $applied++;
    }
    $pdo->commit();
    echo json_encode(['success'=>true,'applied'=>$applied]);
} catch (Throwable $e) {
    $pdo->rollBack();
    http_response_code(500);
    echo json_encode(['success'=>false,'error'=>$e->getMessage()]);
}