<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../config/bootstrap.php';
require_once __DIR__ . '/../src/MT5WebAPI.php';

try {
    $mt5 = new MT5WebAPI();
    
    // Get clients from both groups
    $groups = [
        'skylinkscapital\\A\\Basic',
        'demo\\SK\\G1'
    ];
    
    $allClients = [];
    foreach ($groups as $group) {
        $groupClients = $mt5->getClientsWithAccounts($group);
        $allClients = array_merge($allClients, $groupClients);
    }
    
    $clients = $allClients;
    
    // Format clients for the frontend
    $formatted = array_map(function($client) {
        return [
            'clientId' => $client['RecordID'] ?? '',
            'name' => trim(($client['PersonName'] ?? '') . ' ' . ($client['PersonLastName'] ?? '')),
            'firstName' => $client['PersonName'] ?? '',
            'lastName' => $client['PersonLastName'] ?? '',
            'phone' => $client['Phone'] ?? '',
            'email' => $client['Email'] ?? '',
            'logins' => $client['Logins'] ?? [],
            'loginCount' => count($client['Logins'] ?? []),
        ];
    }, $clients);
    
    echo json_encode($formatted);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}

