# WhatsApp SSL Certificate Fix

## Problem
```
CURL Error: error setting certificate file: \C:\php\extras\ssl\cacert.pem\
```

Your PHP CURL needs the SSL certificate bundle to connect to Meta/Facebook APIs.

## Quick Fix

### Option 1: Download CA Bundle (Recommended)

1. **Download the certificate bundle:**
   ```powershell
   curl -o C:\php\extras\ssl\cacert.pem https://curl.se/ca/cacert.pem
   ```

2. **If directory doesn't exist, create it first:**
   ```powershell
   New-Item -ItemType Directory -Force -Path C:\php\extras\ssl
   curl -o C:\php\extras\ssl\cacert.pem https://curl.se/ca/cacert.pem
   ```

3. **Verify the file exists:**
   ```powershell
   Test-Path C:\php\extras\ssl\cacert.pem
   ```

4. **Test again:**
   ```powershell
   php test_whatsapp.php
   ```

### Option 2: Update php.ini

1. **Open:** `C:\php\php.ini`

2. **Find this line:**
   ```ini
   ;curl.cainfo =
   ```

3. **Replace with:**
   ```ini
   curl.cainfo = "C:\php\extras\ssl\cacert.pem"
   ```

4. **Also find:**
   ```ini
   ;openssl.cafile=
   ```

5. **Replace with:**
   ```ini
   openssl.cafile="C:\php\extras\ssl\cacert.pem"
   ```

6. **Save and test:**
   ```powershell
   php test_whatsapp.php
   ```

### Option 3: Disable SSL Verification (NOT RECOMMENDED for production)

Only for testing:

Edit `src/WhatsAppClient.php` and add:
```php
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
```

**⚠️ This is insecure! Only use for quick testing.**

---

## Run This Now:

```powershell
# Create directory and download cert
New-Item -ItemType Directory -Force -Path C:\php\extras\ssl
curl -o C:\php\extras\ssl\cacert.pem https://curl.se/ca/cacert.pem

# Test
php test_whatsapp.php
```
