## ✅ QUICK FIX - Run This in phpMyAdmin

**Your database connection is blocked by firewall, but you have cPanel access!**

### Steps:

1. **Open phpMyAdmin** in your cPanel:
   - Go to: https://radiant-celery.metalseed.net:2083
   - Find **phpMyAdmin** icon
   - Click it

2. **Select your database**:
   - Click `tradenotify` in the left sidebar

3. **Go to SQL tab**:
   - Click **SQL** at the top menu

4. **Copy and paste this entire SQL** and click **Go**:

```sql
-- Migration: Add Notifications System

-- Table to store notification rules
CREATE TABLE IF NOT EXISTS notifications (
    id INT AUTO_INCREMENT PRIMARY KEY,
    client_id VARCHAR(50) NOT NULL COMMENT 'MT5 Client RecordID',
    client_name VARCHAR(255),
    client_phone VARCHAR(50),
    account_logins TEXT COMMENT 'JSON array of account login numbers',
    trigger_type VARCHAR(50) NOT NULL COMMENT 'open_trade, close_trade, deposit, withdrawal, margin_call, stop_out',
    message TEXT NOT NULL COMMENT 'WhatsApp message template with placeholders',
    enabled TINYINT(1) DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_enabled (enabled),
    INDEX idx_trigger (trigger_type),
    INDEX idx_client (client_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table to track sent notifications (prevent duplicates)
CREATE TABLE IF NOT EXISTS notification_history (
    id INT AUTO_INCREMENT PRIMARY KEY,
    notification_id INT NOT NULL,
    client_id VARCHAR(50) NOT NULL,
    account_login INT NOT NULL,
    trigger_type VARCHAR(50) NOT NULL,
    event_id VARCHAR(255) COMMENT 'MT5 deal/position/balance change ID',
    event_data TEXT COMMENT 'JSON snapshot of event data',
    message_sent TEXT,
    sent_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    wa_message_id VARCHAR(255),
    status ENUM('sent', 'failed', 'pending') DEFAULT 'sent',
    error_message TEXT,
    FOREIGN KEY (notification_id) REFERENCES notifications(id) ON DELETE CASCADE,
    UNIQUE KEY unique_event (notification_id, event_id),
    INDEX idx_sent_at (sent_at),
    INDEX idx_status (status)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table to track last checked time for each notification (for monitoring)
CREATE TABLE IF NOT EXISTS notification_checkpoints (
    notification_id INT PRIMARY KEY,
    last_checked_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    last_event_id VARCHAR(255),
    FOREIGN KEY (notification_id) REFERENCES notifications(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
```

5. **Verify**:
   - You should see "3 tables created" or similar success message
   - Check left sidebar - you should now see:
     - ✓ notifications
     - ✓ notification_history
     - ✓ notification_checkpoints

---

## After Running Migration

Your app will now work! The PHP app can't connect directly due to firewall, but it can work through cPanel's MySQL proxy or you can:

### Option A: Use cPanel MySQL Remote MySQL feature
1. In cPanel → **Remote MySQL**
2. Note if there's a special hostname or port listed
3. Update `.env` with those details

### Option B: Create API endpoints that use mysqli
Some cPanel setups work better with `mysqli` extension. We can create wrapper endpoints.

### Option C: Work around it
1. Run migrations in phpMyAdmin (what we just did)
2. For testing/development, create a local MySQL
3. For production, set up proper SSH tunnel or ask host to open port 3306 for your IP

---

**Run the SQL above in phpMyAdmin now, then let me know if it works!**
