-- ============================================
-- ADD MISSING TABLES to existing tradenotify database
-- This will NOT affect your existing tables
-- Run this in phpMyAdmin SQL tab
-- ============================================

-- 1. Add notifications table (for new UI)
CREATE TABLE IF NOT EXISTS `notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` varchar(50) NOT NULL COMMENT 'MT5 Client RecordID',
  `client_name` varchar(255) DEFAULT NULL,
  `client_phone` varchar(50) DEFAULT NULL,
  `account_logins` text DEFAULT NULL COMMENT 'JSON array of account login numbers',
  `trigger_type` varchar(50) NOT NULL COMMENT 'open_trade, close_trade, deposit, withdrawal, margin_call, stop_out',
  `message` text NOT NULL COMMENT 'WhatsApp message template with placeholders',
  `enabled` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_enabled` (`enabled`),
  KEY `idx_trigger` (`trigger_type`),
  KEY `idx_client` (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 2. Add notification history table
CREATE TABLE IF NOT EXISTS `notification_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `notification_id` int(11) NOT NULL,
  `client_id` varchar(50) NOT NULL,
  `account_login` int(11) NOT NULL,
  `trigger_type` varchar(50) NOT NULL,
  `event_id` varchar(255) DEFAULT NULL COMMENT 'MT5 deal/position/balance change ID',
  `event_data` text DEFAULT NULL COMMENT 'JSON snapshot of event data',
  `message_sent` text DEFAULT NULL,
  `sent_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `wa_message_id` varchar(255) DEFAULT NULL,
  `status` enum('sent','failed','pending') DEFAULT 'sent',
  `error_message` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_event` (`notification_id`,`event_id`),
  KEY `idx_sent_at` (`sent_at`),
  KEY `idx_status` (`status`),
  KEY `notification_id` (`notification_id`),
  CONSTRAINT `notification_history_ibfk_1` FOREIGN KEY (`notification_id`) REFERENCES `notifications` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 3. Add notification checkpoints table
CREATE TABLE IF NOT EXISTS `notification_checkpoints` (
  `notification_id` int(11) NOT NULL,
  `last_checked_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `last_event_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`notification_id`),
  CONSTRAINT `notification_checkpoints_ibfk_1` FOREIGN KEY (`notification_id`) REFERENCES `notifications` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- VERIFICATION
-- ============================================
-- Show all tables (should now include notifications tables)
SHOW TABLES;

-- Check if notifications table exists
SELECT COUNT(*) as notifications_count FROM notifications;

-- Success message
SELECT 'Database setup complete! All tables created successfully.' as Status;
